#ifndef __SokoDefaults_h
#define __SokoDefaults_h
//-----------------------------------------------------------------------------
// SokoDefaults.h
//
//	Concrete implementation of abstract SokoSettingDelegate which
//	provides SokoSetting module with required implementation-specific
//	functionality.
//
// Copyright (c), 2001, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoDefaults.h,v 1.1 2001/12/21 21:46:43 sunshine Exp $
// $Log: SokoDefaults.h,v $
// Revision 1.1  2001/12/21 21:46:43  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//
//-----------------------------------------------------------------------------
#include "SokoSetting.h"
#include <vcl/system.hpp>
#include <vcl/dstring.h>

class SokoDefaults : public SokoSettingDelegate
    {
private:
    AnsiString buffer;
public:
    static void initialize();
    static void shutdown();
    SokoDefaults() {}
    virtual ~SokoDefaults() {}
    virtual soko_bool exists( SokoSetting*, char const* name );
    virtual char const* get( SokoSetting*, char const* name, cSokoPool );
    virtual void set( SokoSetting*, char const* name, char const* value );
    virtual void remove( SokoSetting*, char const* name );
    virtual char const* factory_path( SokoSetting*, cSokoPool );
    virtual char const* user_path( SokoSetting*, cSokoPool );
    };

#endif // __SokoDefaults_h
