#ifndef SokoBoard_h
#define SokoBoard_h
//-----------------------------------------------------------------------------
// SokoBoard.h
//
//	Implementation of a Sokoban puzzle board for SokoSave.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoBoard.h,v 1.3 2002/05/06 05:48:52 sunshine Exp $
// $Log: SokoBoard.h,v $
// Revision 1.3  2002/05/06 05:48:52  sunshine
// v19
// -*- Fixed v17 Win9x problem where animation of Hexoban and Trioban puzzles
//     involved unsightly "flashing" which resulted from Windows first
//     painting the on-screen hexagonal and triangular tiles black before
//     blitting in the actual tile.  To work around the problem,
//     SokoGridHexagon and SokoGridTriangle now maintain a backing-store in
//     which the puzzle image is rendered.  When the on-screen image needs to
//     be repainted, only non-transparent rectangles are blitted to the
//     screen.  This patch cuts animation speed effectively in half for
//     Hexoban and Trioban puzzles, but the visual quality of the animation
//     is much improved.  This problem did not affect WinNT or Win2000.
//
// Revision 1.2  2002/01/29 22:12:35  sunshine
// v17
// -*- Added support for the new hexagonal-style puzzles.
//
// -*- No longer uses TDrawGrid for display of puzzle.
//
// -*- Added TSokoGrid, a subclass of TGraphicControl which is the base class
//     for grids which display puzzle boards.
//
// -*- Added TSokoGridSquare, a subclass of TSokoGrid, which knows how to
//     draw square-tiled puzzles, and perform appropriate hit-testing.
//
// -*- Added TSokoGridHexagon, a subclass of TSokoGrid, which knows how to
//     draw hexagon-tiled puzzles, and perform appropriate hit-testing.
//
// -*- SokoPuzzle now calculates two new scores in addition to "moves" and
//     "pushes".  The "runs" score is the number of straight lines in which
//     crates have been pushed.  Looked at another way, it is the number of
//     turns crates have made while being pushed.  The "focus" score is the
//     number of times the player's focus has changed from one crate to
//     another.
//
// -*- Added "runs" and "focus" scores controls to SokoBoard.
//
// -*- Relocated functionality of soko_save_filename_for_puzzle(),
//     soko_puzzle_name_for_level(), and soko_level_for_puzzle_name() from
//     SokoFile to SokoPuzzle, where they are class methods of SokoPuzzle.
//
// -*- Extended keyboard movement support.  Numeric keypad can now be used,
//     as well as standard arrow keys.  Added key equivalents for hexagonal
//     puzzles.
//
// -*- Fixed a number of aesthetic problems which showed up when using larger
//     control sizes and fonts.  Controls would clobber one another and text
//     would be clipped.  The problems were particularly acute when using
//     "Large Fonts" from the Windows Display/Advanced settings.
//
// -*- SokoBoard's score labels now have AutoSize enabled.  This allows them
//     to grow as needed when user has selected a large font size, thus
//     preventing the text on the labels from being clipped.
//-----------------------------------------------------------------------------
#include <Buttons.hpp>
#include <Classes.hpp>
#include <ComCtrls.hpp>
#include <Controls.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <StdCtrls.hpp>
#include <ToolWin.hpp>
#include "SokoForm.h"
#include "SokoPuzzle.h"
class TSokoGrid;

class TSokoBoardForm : public TSokoForm
    {
    typedef TSokoForm superclass;
__published:
    TPanel* control_panel;
    TPanel* status_panel;
    TLabel* moves_label;
    TLabel* moves_field;
    TBevel* moves_underline;
    TLabel* pushes_label;
    TLabel* pushes_field;
    TBevel* pushes_underline;
    TLabel* runs_label;
    TLabel* runs_field;
    TBevel* runs_underline;
    TLabel* focus_label;
    TLabel* focus_field;
    TBevel* focus_underline;
    TPanel* move_panel;
    TSpeedButton* up_button;
    TSpeedButton* up_right_button;
    TSpeedButton* up_left_button;
    TSpeedButton* left_button;
    TSpeedButton* right_button;
    TSpeedButton* down_button;
    TSpeedButton* down_left_button;
    TSpeedButton* down_right_button;
    TPanel* playback_panel;
    TSpeedButton* undo_push_button;
    TSpeedButton* undo_move_button;
    TSpeedButton* redo_move_button;
    TSpeedButton* redo_push_button;
    TTrackBar* playback_slider;
    TCheckBox* animate_switch;
    TButton* stop_button;
    TLabel* solved_label;
    TBevel* bevelv1;
    TBevel* bevelh1;
    TBevel* bevelv2;
    TMainMenu* main_menu;
    TMenuItem* game_menu;
    TMenuItem* new_item;
    TMenuItem* next_item;
    TMenuItem* open_item;
    TMenuItem* N1;
    TMenuItem* close_item;
    TMenuItem* save_item;
    TMenuItem* save_as_item;
    TMenuItem* save_all_item;
    TMenuItem* N2;
    TMenuItem* preferences_item;
    TMenuItem* N3;
    TMenuItem* exit_item;
    TMenuItem* history_menu;
    TMenuItem* undo_move_item;
    TMenuItem* redo_move_item;
    TMenuItem* undo_push_item;
    TMenuItem* redo_push_item;
    TMenuItem* window_menu;
    TMenuItem* cascade_item;
    TMenuItem* minimize_item;
    TMenuItem* minimize_all_item;
    TMenuItem* N4;
    TMenuItem* help_menu;
    TMenuItem* instructions_item;
    TMenuItem* scores_item;
    TMenuItem* N5;
    TMenuItem* about_item;
    TPanel* toolbar_panel;
    TToolBar* info_toolbar;
    TSpeedButton* show_help_button;
    TSpeedButton* show_scores_button;
    TToolBar* game_toolbar;
    TSpeedButton* next_puzzle_button;
    TSpeedButton* new_game_button;
    TSpeedButton* open_game_button;
    TSpeedButton* save_game_button;
    TPopupMenu* configuration_popup;
    TMenuItem* toggle_toolbar_item;
    TPanel* puzzle_panel;
    TTimer* button_timer;
    void __fastcall form_close( TObject* sender, TCloseAction& action );
    void __fastcall form_create( TObject* sender );
    void __fastcall preferences_item_click( TObject* sender );
    void __fastcall new_game_click( TObject* sender );
    void __fastcall next_puzzle_click( TObject* sender );
    void __fastcall open_game_click( TObject* sender );
    void __fastcall close_item_click( TObject* sender );
    void __fastcall save_game_click( TObject* sender );
    void __fastcall save_as_click( TObject* sender );
    void __fastcall save_all_click( TObject* sender );
    void __fastcall exit_item_click( TObject* sender );
    void __fastcall diagonal_button_click( TObject* sender );
    void __fastcall direction_button_click( TObject* sender );
    void __fastcall animate_switch_click( TObject* sender );
    void __fastcall stop_button_click( TObject* sender );
    void __fastcall undo_move_click( TObject* sender );
    void __fastcall redo_move_click( TObject* sender );
    void __fastcall undo_push_click( TObject* sender );
    void __fastcall redo_push_click( TObject* sender );
    void __fastcall playback_slider_change( TObject* sender );
    void __fastcall timer_fired( TObject* sender );
    void __fastcall repeat_button_mouse_down(
	TObject* sender, TMouseButton button, TShiftState shift, int x, int y);
    void __fastcall repeat_button_mouse_up(
	TObject* sender, TMouseButton button, TShiftState shift, int x, int y);
    void __fastcall key_down(
	TObject* sender, WORD& key, TShiftState shift );
    void __fastcall key_up(
	TObject* sender, WORD& key, TShiftState shift );
    void __fastcall puzzle_grid_mouse_down(
	TObject* sender, TMouseButton button, TShiftState shift, int x, int y);
    void __fastcall puzzle_grid_mouse_up(
	TObject* sender, TMouseButton button, TShiftState shift, int x, int y);
    void __fastcall puzzle_grid_mouse_move(
	TObject* sender, TShiftState shift, int x, int y );
    void __fastcall form_deactivated( TObject* sender );
    void __fastcall cascade_item_click( TObject* sender );
    void __fastcall minimize_item_click( TObject* sender );
    void __fastcall minimize_all_item_click( TObject* sender );
    void __fastcall show_scores_click( TObject* sender );
    void __fastcall show_help_click( TObject* sender );
    void __fastcall about_item_click( TObject* sender );
    void __fastcall toggle_toolbar_click( TObject* sender );
private:
    SokoPuzzle* puzzle;
    TSokoGrid* puzzle_grid;
    TSpeedButton* timed_button;
    bool sizing_self;
    int record_moves;
    int record_pushes;
    int record_runs;
    int record_focus;
    int grid_inset_x;
    int grid_inset_y;
    int grid_min_width;
    int grid_min_height;
    int idle_count;
    void create_grid();
    void capture_form_constraints();
    void adjust_form_size();
    void refresh_window_title();
    void refresh_toolbar_state();
    void enable_toolbar( bool );
    void check_for_next_puzzle();
    void configure_images();
    void configure_controls();
    void configure_board( SokoPuzzle* );
    void record_score( int moves, int pushes, int runs, int focus );
    void record_level( int level );
    void set_solved( bool solved );
    void set_dirty( bool dirty );
    void refresh_controls();
    void refresh_all_cells();
    void refresh_cells( SokoCell const*, int );
    bool should_animate_playback() const;
    int  playback_threshold() const { return 40; }
    void begin_playback();
    void end_playback();
    void begin_animation() {}
    void end_animation() {}
    void begin_drag();
    void end_drag();
    void process_events( bool await_event );
    void abort_playback();
    void start_idle_monitor();
    void stop_idle_monitor();
    void handle_app_idle( bool& done );
    void handle_app_deactivated();
    SokoEventFlags event_flags_for_state( TShiftState ) const;
    void key_action( WORD& key, soko_bool down, TShiftState shift );
    void mouse_action(
	TMouseButton button, soko_bool down, TShiftState shift, int x, int y );
    void wm_size( Messages::TMessage& );
    void wm_syscolorchange( Messages::TMessage& );
    static bool open_puzzles( TStrings* );
    static bool open_puzzle_for_level( int level );
    friend class SokoBoardDelegate;
protected:
    BEGIN_MESSAGE_MAP
	MESSAGE_HANDLER(WM_SIZE, TMessage, wm_size);
	MESSAGE_HANDLER(WM_SYSCOLORCHANGE, TMessage, wm_syscolorchange);
    END_MESSAGE_MAP(superclass);
public:
    static bool open_next_puzzle();
    static bool open_puzzle( char const* path );
    static bool choose_puzzle();
    static void enable_toolbars( bool );
    static void app_deactivated();
    static void app_idle( bool& done );
    __fastcall TSokoBoardForm( TComponent* owner );
    virtual __fastcall ~TSokoBoardForm();
    };

extern PACKAGE TSokoBoardForm* SokoBoardForm;

#endif // SokoBoard_h
