#ifndef SokoApp_h
#define SokoApp_h
//-----------------------------------------------------------------------------
// SokoApp.h
//
//	Global hidden form representing application instance.
//
// Copyright (c), 2001,2002, Eric Sunshine <sunshine@sunshineco.com>
// All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoApp.h,v 1.2 2002/02/19 07:50:05 sunshine Exp $
// $Log: SokoApp.h,v $
// Revision 1.2  2002/02/19 07:50:05  sunshine
// v18
// -*- Added support for new triangular-style Trioban puzzles.
//
// -*- Fixed bug: Some of the file mask descriptions on the new/open panels
//     had an errant leading semi-colon.
//
// -*- Now notifies Windows shell after all file associations have been made,
//     rather than after each registration.
//
// Revision 1.1  2001-12-21 16:47:25-05  sunshine
// v15
// -*- Extracted core game logic out of GUI code and generalized it so that
//     the same core code can be used by any platform.  Logic from
//     SokoBoard.m now resides in SokoPuzzle.c, etc.
//
// -*- Created a native Windows port of SokoSave using C++Builder.  The
//     back-end logic for this port is provided by the new "sokocore" common
//     code which used to be merged with the UI code for the
//     OpenStep/NextStep ports.  From the user-experience, this port is
//     nearly identical to the existing OpenStep and NextStep ports.  Builds
//     successfully with C++Builder versions 4 and 5.
//
// -*- Added a shortcut toolbar for quickly starting new games, opening saved
//     games, saving games, launching the scores panel, and launching the
//     help file.  Added a toggle-switch to the preferences panel to control
//     presence of toolbar.  From the user-standpoint, this is the only major
//     difference from the OpenStep/NextStep ports, since they do not feature
//     a shortcut toolbar.
//
// -*- Created an InnoSetup installer script for SokoSave.  This scripts
//     facilitates the creation of a stand-alone "setup" program
//     (soksetup.exe) for SokoSave.  With this program, Windows users can
//     download and install SokoSave in a fashion in which they are already
//     familiar.
//-----------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include "SokoForm.h"
class SokoRendezvous;

class TSokoAppForm : public TSokoForm
    {
__published:
    TOpenDialog* new_dialog;
    TOpenDialog* open_dialog;
    TSaveDialog* save_dialog;
    TLabel* dummy_label;
    void __fastcall form_create( TObject* sender );
private:
    TList* hidden_windows;
    void __fastcall app_minimized( TObject* sender );
    void __fastcall app_restored( TObject* sender );
    void __fastcall app_deactivated( TObject* sender );
    void __fastcall app_idle( TObject* sender, bool& done );
    void __fastcall secondary_launched( char const* );
    void register_file_associations();
    bool register_file_association( char const* ext, AnsiString icon_path,
	int icon_index, char const* desc );
    void configure_dialogs();
    bool choose_puzzle();
    void report_open_failure( char const* path );
public:
    __fastcall TSokoAppForm( TComponent* owner );
    virtual __fastcall ~TSokoAppForm();
    void set_rendezvous_point( SokoRendezvous* );
    void launch_about();
    void launch_preferences();
    void launch_scores();
    void launch_instructions();
    };

extern PACKAGE TSokoAppForm* SokoAppForm;

#endif // SokoApp_h
